import pandas as pd
import matplotlib.pyplot as plt
import re

# Chemin vers ton fichier CSV
file_path = "/Users/lara/Desktop/L3_physique/S6/projet /données oscillo /ALL0004/F0004CH2.CSV"  # Assure-toi que le fichier est dans le même dossier que ton script Python

# Étape 1 : Extraire les données utiles
time_vals = []
voltage_vals = []

with open(file_path, 'r') as f:
    for line in f:
        # Trouver tous les nombres à virgule flottante
        numbers = re.findall(r'-?\d+\.\d+(?:e[+-]?\d+)?', line)
        if len(numbers) == 2:
            try:
                time_vals.append(float(numbers[0]))
                voltage_vals.append(float(numbers[1]))
            except ValueError:
                continue

# Création du DataFrame
data = pd.DataFrame({'Time': time_vals, 'Voltage': voltage_vals})

# Étape 2 : Tracer le signal complet
plt.figure(figsize=(12, 4))
plt.plot(data['Time'], data['Voltage'])
plt.title("Signal complet extrait")
plt.xlabel("Temps (s)")
plt.ylabel("Tension (V)")
plt.grid(True)
plt.show()
# Étape 3 : Zoom sur tout le pic autour du minimum
min_index = data['Voltage'].idxmin()

# Largeur plus large autour du pic
window = 20  # <<<<< plus large pour voir toute la forme

# Définir les bornes du zoom
start = max(min_index - window, 0)
end = min(min_index + window, len(data))

# Tracer la zone du pic
plt.figure(figsize=(12, 4))
plt.plot(data['Time'].iloc[start:end], data['Voltage'].iloc[start:end])
plt.title("Visualisation élargie du pic négatif")
plt.xlabel("Temps (s)")
plt.ylabel("Tension (V)")
plt.grid(True)
plt.tight_layout()
plt.show()
